<?php
/**
 * Functions
 *
 * @package     AutomatorWP\Thrive_Quiz_Builder\Functions
 * @since       1.0.0
 */
// Exit if accessed directly
if( !defined( 'ABSPATH' ) ) exit;

/**
 * Get predefined quiz types in Thrive Quiz Builder
 *
 * @since 1.0.0
 *
 * @return array
 */
function automatorwp_thrive_quiz_builder_options_cb_quiz_types(){
    // Quiz types
    $types = array(
        'any'           => __( 'any type', 'automatorwp-pro' ),
        'number'        => __( 'Number', 'automatorwp-pro' ),
        'percentage'    => __( 'Percentage', 'automatorwp-pro' ),
        'personality'   => __( 'Personality', 'automatorwp-pro' ),
        'right_wrong'   => __( 'Right/Wrong', 'automatorwp-pro' ),
        'survey'        => __( 'Survey', 'automatorwp-pro' )
    );

    return $types;
}


/**
 * Options callback for select2 fields assigned to percentage quizzes
 *
 * @since 1.0.0
 *
 * @param stdClass $field
 *
 * @return array
 */
function automatorwp_thrive_quiz_builder_options_cb_percentage_quiz( $field ) {

    // Setup vars
    $value = $field->escaped_value;
    $none_value = 'any';
    $none_label = __( 'any quiz', 'automatorwp-pro' );
    $options = automatorwp_options_cb_none_option( $field, $none_value, $none_label );

    if( ! empty( $value ) ) {
        if( ! is_array( $value ) ) {
            $value = array( $value );
        }

        foreach( $value as $quiz_id ) {

            // Skip option none
            if( $quiz_id === $none_value ) {
                continue;
            }
            
            $options[$quiz_id] = get_the_title( $quiz_id );
        }
    }

    return $options;


}

/**
 * Get quizzes with percentage type
 *
 * @since 1.0.0
 *
 * @return array
 */
function automatorwp_thrive_quiz_builder_get_percentage_quizzes() {

    $quizzes = get_posts( array(
        'numberposts' => -1,
        'post_type' => 'tqb_quiz',
        'meta_query' => array(
            array(
                'key'       => 'tqb_quiz_type',
                'value'     => 'percentage',
                'compare'   => 'LIKE',
            )
        )
    ) );

    return $quizzes;
}